<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no" />
<xsl:param name="searchTxtVar"></xsl:param>
<xsl:param name="searchTypeVar"></xsl:param>
<xsl:param name="showFromVar">1</xsl:param>
<xsl:param name="showToVar">100</xsl:param>

<xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
     
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="$searchTypeVar='subsumes'"><h4>"<xsl:value-of select="$searchTxtVar"/>:  
			<xsl:for-each select="/OntoWiktionary/Concept[@id=$searchTxtVar]/Lexicalization">
				<xsl:value-of select="@lemma" />; 
			</xsl:for-each>					
			" subsumes:</h4>
		</xsl:when>
		<xsl:when test="$searchTypeVar='subsumedBy'"><h4>"<xsl:value-of select="$searchTxtVar"/>: 
			<xsl:for-each select="/OntoWiktionary/Concept[@id=$searchTxtVar]/Lexicalization">
				<xsl:value-of select="@lemma" />; 
			</xsl:for-each>		
			" is subsumed by</h4>
		</xsl:when>	
		<xsl:when test="$searchTypeVar='related'"><h4>"<xsl:value-of select="$searchTxtVar"/>: 
			<xsl:for-each select="/OntoWiktionary/Concept[@id=$searchTxtVar]/Lexicalization">
				<xsl:value-of select="@lemma" />; 
			</xsl:for-each>		
			" is related to</h4>
		</xsl:when>				
		<xsl:when test="string-length($searchTxtVar)>0">Searching for: "<xsl:value-of select="$searchTxtVar"/>"<br/></xsl:when>
	</xsl:choose>
		
    <div id="searchResHeader">
	   Results <xsl:value-of select="$showFromVar"/>-<xsl:value-of select="$showToVar"/>
	   <h4>Search Results:</h4>
	</div>
		
	<table id="conceptTable">
	
	<tr id="headerRow">
		<th id="conceptIdHeader">Concept ID</th>
		<td>
		<table id="headerLexicTable">
			<tr>			
				<th class="lexicId">Lexicalization ID</th>
				<th class="lemma">Lemma</th>
				<th>Gloss</th>
			</tr>
		</table>
		</td>
	</tr>	
		
	<xsl:for-each select="/OntoWiktionary/Concept[string-length($searchTxtVar)=0 or
			($searchTypeVar='conceptId' and @id=$searchTxtVar) or
	        ($searchTypeVar='subsumes' and SubsumedBy[@target_id=$searchTxtVar]) or
	        ($searchTypeVar='subsumedBy' and Subsumes[@target_id=$searchTxtVar]) or	     
	        ($searchTypeVar='related' and RelatedConcept[@target_id=$searchTxtVar]) or	         
	        ($searchTypeVar='lemmaExact' and Lexicalization[translate(@lemma, $uppercase, $lowercase)=translate($searchTxtVar, $uppercase, $lowercase)]) or
		    ($searchTypeVar='lemmaContains' and Lexicalization[contains(translate(@lemma, $uppercase, $lowercase), translate($searchTxtVar, $uppercase, $lowercase))]) or
		    ($searchTypeVar='glossContains' and Lexicalization[contains(translate(text(), $uppercase, $lowercase), translate($searchTxtVar, $uppercase, $lowercase))])
	  		]">
     	  <xsl:sort select="@id" data-type="number" order="ascending"/>
		  <xsl:if test="position() >= $showFromVar and position() &lt;= $showToVar">
		  		<tr>
		    	<xsl:choose>
					<xsl:when test="position() mod 2 = 1"><xsl:attribute name="class">unevenRow</xsl:attribute></xsl:when>
					<xsl:otherwise><xsl:attribute name="class">evenRow</xsl:attribute></xsl:otherwise>
				</xsl:choose>			
				
				<td>
				<table class="conceptIdTable">
					<tr style="vertical-align:top">
						<td>
							<b><xsl:value-of select="@id" /></b>
						</td>
					</tr>
					<tr style="vertical-align:bottom">	
						<td>				
			        		<a href="#" onclick="showRelation(this.rel, 'subsumes')" class="relationLink">
			        			<xsl:attribute name="rel"><xsl:value-of select="@id" /></xsl:attribute>						 		        
			        	       	Subsumes (<xsl:value-of select="count(Subsumes)" />)</a>  
			        		<br />		        	
			        		<a href="#" onclick="showRelation(this.rel, 'subsumedBy')" class="relationLink">
			        			<xsl:attribute name="rel"><xsl:value-of select="@id" /></xsl:attribute>												 		        
			        			SubsumedBy (<xsl:value-of select="count(SubsumedBy)" />)</a>
			        		<br />
			        		<a href="#" onclick="showRelation(this.rel, 'related')" class="relationLink">
			        			<xsl:attribute name="rel"><xsl:value-of select="@id" /></xsl:attribute>						 		        
			        	       	Related (<xsl:value-of select="count(RelatedConcept)" />)</a>  
			        		<br />	
		        		</td>
					</tr>
				</table>
				</td>			
		     	   	        
		      	<td><table class="lexicTable">
		      	<xsl:for-each select="Lexicalization">
		        	<tr>
		        		<td class="lexicId"><xsl:value-of select="@id" /></td>
		        		<td class="lemma">		        		
		        			<a href="#" onclick="searchType(this.childNodes[0].nodeValue, 'lemmaExact')" class="lemmaLink">		        				
		        				<xsl:value-of select="@lemma" />
		        			</a>		        		
		        		</td>		        		
		        		<td><xsl:value-of select="text()" /></td>       
		    		</tr>
		        </xsl:for-each>
		       
		     	</table>		     	
		     	</td>		     	
	    	</tr>    	  
	    </xsl:if>
    </xsl:for-each>
</table>
</xsl:template>

</xsl:stylesheet>

